setwd("path to workspace")
library(fixest)
library(scales)
library(lmtest)
library(sandwich)
library(multiwayvcov)

####monetary effect
data <- read.csv('10052024_incentive_data.csv') ## monetary incentive data

model_econ_perf <- feols(performance ~ as.factor(group) + log(time_spent),vcov=~as.factor(user_id), data)
summary(model_econ_perf)
####quiz effect
data_quiz <- read.csv('10052024_quiz_regression.csv')
##t-test with clustered standard errors on user_id
model <- lm(data_quiz$performance ~ data_quiz$group + log(time_spent), data = data_quiz)
# Calculate clustered standard errors
clustered_se <- cluster.vcov(model, ~ user_id)
# Perform t-test with clustered standard errors
coeftest(model, vcov = clustered_se)

model_econ_perf <- feols(performance ~ as.factor(group) + log(time_spent),vcov=~as.factor(user_id), data_quiz)
summary(model_econ_perf)
############################################################
####ml effect
data <- read.csv('10052024_ml_experiment.csv')

data$optrate <- ifelse(data$performance == 1, 1, 0)

model_econ_perf <- feols(optrate ~ treatment+log(time_spent),vcov=~as.factor(user_id), data)
summary(model_econ_perf)

data = subset(data, treatment %in% c("yes_monetary_no_ml", "yes_monetary_yes_ml_q1"))
model <- lm(performance ~ treatment + log(time_spent), data = data)
# Calculate clustered standard errors
clustered_se <- cluster.vcov(model, ~ user_id)
# Perform t-test with clustered standard errors
coeftest(model, vcov = clustered_se)
